
.PL 56;RM 70;LM 10;FI;AD;IN +0

.CE 2

A GUIDE TO THE p-System

on the TI 99/4a





[Note: this is the first draft
of this document...please make
comments via MUSUS, the TI Forum
or EMAIL (my # is 72406,2754),
or US Mail, or via TI-Writer
disks. My address is:

.IN +10

1540 Florida Ave. #205

Modesto, Ca 95350

.IN +0



I especially request help and
comments at the places where I
have placed percent signs
(%%%)]





.CE 1

Introduction 

When TI discontinued the machine
in October, 1893, few of the
over two million 99/4 owners
were using the p-System; if all
99/4 owners felt like orphans,
we p-System users were doubly
so.  But however isolated we
seem there are advantages: the
p-System on the 99/4a is a full
implementation of a "serious"
operating system and as such we
are able to do much more with it
than TI-BASIC.  Also, we can get
help from any p-System user,
regardless of their hardware.
Finally, when the day comes when
our machines either die or are
outgrown, our programs will be
portable to virtually any other
machine on the market.



The purpose of this guide is to
orient the TI 99/4a user to the
p-System in general, and point
out the special considerations
about its implementation on our
machine. It is hoped that this
guide will be of value to all
who are interested, from the
serious programmer to those who
are considering purchasing the
p-System





.CE

Overview of the p-System



The p-System is an operating
system -- a set of programs to
run the computer and allow us to
write and run programs. It is
&not a language; any language
might be available under the
p-System.  While only PASCAL is
currently available to us, other
users of the p-System can use
BASIC, FORTRAN, and MODULA-2.



This concept is confusing to
many TI 99/4 users because TI
Console and Extended BASIC have
the operating system built in --
they include text editors, disk
management programs, etc -- all
in the ROM containing BASIC. In
the p-System one adresses all
these functions separately, and
most are on disk.



The essential part of the
p-System for the TI99/4a is the
p-Code card (or the old p-Code
peripheral). The p-Code card
contains some of the system
programs in ROM. You
must also have the 32K memory
expansion.  There is currently
no way to use the extra 96K RAM
available in the 128K card
manufactured by Foundation. A
disk is not absolutely
necessary, as programs can be
loaded and run from casette.
However, I do not know of any
casette programs, nor do I know
of anyone who has used a casette
with the p-System.



The p-Code card includes, in
ROM, the p-Code interpreter.
This program accepts the user's
and system programs in p-Code
and executes them by
interpreting them into 9900
machine instructions.



Anyone serious about the
p-System will have to have at
least one and preferably two
disk drives. The p-System will
support double sided disk
drives. If you is going to make
use of the p-System for writing
programs, then you will find
that in a single drive system
that your drive had better be
double sided; two drives are
better and two double sided
drives are best. I see little
use for a third drive. %%% Does
anyone know if the Corcomp
double density controller allows
double density disks on the
p-System (360 single sided,
720blocks double sided)?%%%



A printer is certainly useful
for the serious p-System user
and can be supported through the
RS232 (and PIO) card.
%%%%anybody had experiences with
other RS232 and PIO cards,
peripherals, etc -- by 3rd party
manufacturers?%%%%


There are several programs that
are important parts of the
p-System. One is the PASCAL
compiler, the program that takes
PASCAL programs and translates
them to p-Code, so the p-Code
card can run them.  This program
comes on disk and is necessary
to write your own programs but
not to run someone else'
programs.



Another disk contains two
important programs: the Editor
and Filer.  The Editor is used
to edit documents and programs;
you only need this to write your
own programs although it can
even, to some extent, be used
for word processing.  The Filer
manages the disks; virtually any
user of the p-System needs this
program.  Also on this disk are
a number of utility programs
which are of much value to most
users.  



The last disk contains the
Assembler and Linker, both of
which are necessary to do
assembly language programming.







.CE

Learning to use the p-System



The TI manuals that come with
the system components are pretty
good as manuals go, but are not
designed to teach the basic use
of the system. There are many
books about the U.C.S.D.
p-System and PASCAL.  Two very
useful books are: "Introduction
to the UCSD p-System" by Grant
and Butah (Sybex), and "The
UCSD PASCAL Handbook" by Clark
and Koehler (Reward Books). The
former is an excellent
introduction to the use of the
p-System. This guide will
describe the unique aspects of
our implementation by comparing
the TI 99/4a system to that
described in this book.  The
latter book is a relatively
technical guide to UCSD PASCAL
with very good examples. There
are a number of good books that
teach PASCAL; a discussion of
them is beyond the scope of this
guide.



USUS (the U.C.S.D. p-System
users' Group) is a good source
of help in the use of the
system. Many of its members can
easily be reached via the MUSUS
SIG on Compuserve (PCS-55). The
beauty of the p-System is that
it, at least in theory, acts
exactly the same on all systems;
thus, you can get help from any
knowledgeable p-System user;
MUSUS is a good place to find
such people.  







.CE

The Filer



The Filer works pretty much as
described by Grant and Butah.
The major exceptions are that
some of the prompts are shorter
and the TI 99/4 only displays 40
columns at once. To see the
whole 80 column display one uses
the FCTN-7 and FCTN-8 keys
(screen left and right).



It should be noted that disks
may be physically in the drives
but cannot be addressed by their
volume names unless they were
present at startup of the
p-System, or reinitialization (I
command) or by invoking the V
(Volumes) command of the Filer.
This command doesn't just list
the on-line diskettes, but
formally recognizes them so that
they can be accessed by volume
name in user programs. If you
want to use the FILER but didn't
have it in a disk drive at start
up, then you have a problem. You
cannot invoke the FILER V
command to get the system to
recognize the disk - because you
can't run the FILER. The
solution to this catch-22 is to
use the system I command and
restart the system. On restart,
the p-System looks anew at the
disk drives, and will then
recognize the diskettes loaded
in them, and know where to find
the FILER, EDITOR, etc.



The Z (zero) command sets up a
new (or zeros an old disk) after
it has been formatted by the
DFORMAT utility program (or the
Disk Manager Cartridge). Single
sided disks have 180 (512 byte)
blocks, double sided disks are
twice that size. Using duplicate
directories consumes 4 extra
blocks but will often avert
disaster when disk failure
occurs.







.CE

The Editor





The Editor for the 99/4 is that
which Grant and Butah call the
"Screen Oriented Editor"  -- the
Editor that is discussed at
length in their book. In general
the Editor works just like that
of Grant and Butah with a few
differences that could probably
be best described as bugs. The
"S" (Same) option on the "F"
(Find) command does not work.
The copy buffer seems to be
emptied at times for reasons
that are not obvious. After
repeated insertions and
deletions of a given page on
screen, often the screen image
is not correct. The actual text
is different. As a result, it is
best to use the "V" (Verify)
command when in doubt. It
re-displays the current screen
page.



The 99/4a's small RAM size
allows only a little more than
12k characters in the text
buffer. If you need to break
down a larger file the AUTOPSY
program in the USUS library can
be of help. Programs can be
written in several parts and
strung together with the PASCAL
compiler {$I} (include file)
command.





.CE

Compiler



The TI 99/4a PASCAL compiler is
a full Version IV.0
implementation. It seems to be
identical to the compiler
described by Clark and Koehler.
In its TI version, the Compiler
appears to be in four parts: 1)
the start-up code; 2) the code
to process the Declarations, 3)
the code to process the body of
procedures, and 4) the code to
produce p-Codes. Parts 2 and 3
are swaped in and out for each
procedure in the program, making
comipilation a good time for a
coffee break. The swap
parameters described by Grant
and Butah seem to be inoperative
on the TI; I suspect that the
compiler is set for maximum
swapping to accomidate the TI's
limited RAM.  Making a listing
causes the already slow compiler
to run much slower still , so
one should be sparing in using
this function. Also, if errors
are found by the compiler it may
not make a listing, even if the
user keeps continuing
compilation to the end. It may
even hang with the error:

.CE 2



STACK OVERFLOW*REBOOT



At this point, one must turn the
console off and on again and to
restart.



The TI 99/4 version of PASCAL
includes a number of extensions
that allow the use of the
special capabilities of the
machine. These extensions are in
the form of procedures included
in the "TEXAS INSTRUMENTS
UNITS", which are in the system
LIBRARY. These inclue the
routines to change screen color,
use graphic modes (bit map,
multi-color, etc), sprites,
sound and speech. The use of
these routines will allow the
sophisticated user to do in a
high level language what
otherwise was previously only
possible in Assembly. The new TI
FORTH posesses these features as
well. Please note, however, that
the use of these procedures will
make the program machine
dependent, and thus not
portable. One cannot, for
example expect a program using
sprites to run properly on an
APPLE, because that machine
lacks the hardware to produce
them. To keep a program
portable, one should avoid using
the facilities in the TEXAS
INSTRUMENTS UNITS. 



Among the routines included in
these UNITS, I have only used
the prcedures for random number
generation and screen color
definition.  These procedures
work as specified. I welcome
input from others who have used
the other facilities.  



For program development, it is
desirable to be able to quickly
go from compiler to editor, so
it is good to have both programs
on one disk or both on different
disks on different drives (in a
multi-drive system). Also, put
the file SYSTEM.PASCAL on the
ROOT volume so that meaningful
error messages are displayed. 









.CE

Utilities



There are a number of valuable
programs included with the
Editor and Filer disk. This
guide will discuss the most
useful of these programs.



DFORMAT formats new disks (or
reformats old ones). It serves
the same function as the Disk
Manager module in this function.
It can format double sided disks
but usually fails (I was told
by TI that they knew of this
bug) but works fine on single
sided disks. For double sided
disks, one can always use the
Disk Manager 2 module if
available. The Z)ero command in
the FILER must still be used in
either case before a disk is
usable.



MARKDUPDIR and COPYDUPDIR are
useful in dealing with duplicate
directories on disk, whose use
is highly recomended.



MODRS232 alters the device
definition associated with
REMIN: and REMOUT: (these use
the same definition) and
PRINTER:. TI has kindly included
the source code for these
programs. If you use a printer
whose definition is different
from the default
(RS232/2.BA=9600.DA=7.PA=O.EC --
this probably isn't what you're
using), you can alter the source
code to make the printer
definition without user
prompting and run it as
SYSTEM.STARTUP. The rules for
describing the RS232 or PIO
communication setup are the same
as used by BASIC.



RECOVER is useful if an both
directories are blown (or you
foolishly used only single
directories).  It can help
restore lost files.  PATCH will
allow repair of individual
files. You have to be a very
expert user to use PATCH,
however.



SETLTYPE allows one to force a
program to reside in RAM rather
than VDPRAM. Its stated purpose
is to declare whether a program
is in p-Codes or native code
(machine language). Machine
language programs must reside in
RAM; p-Code programs may be in
RAM or VDPRAM as the p-System
selects (usually in VDPRAM). The
system views both VDPRAM and RAM
as one large space to be filled
with programs and data. It will
store data down from the high
end of RAM and programs up from
the low end of VDPRAM until RAM
or VDPRAM is filled; then it
will overflow into the other
space (i.e. programs will
overflow in RAM or data into
VDPRAM). One can use SETLTYPE to
force a program or segment to be
in RAM. If this is done it will
run somewhat faster, but may
impinge on (and thereby limit)
the area for data. As mentioned
above, assembly language
programs must be put in RAM with
SETLTYPE.







.CE

Using the p-System





Several notes can be made about
using the p-System on the
TI99/4a. First, you cannot use
the TI LOGO cartridge on a
system with the p-Code card in
place.  The p-System will work
fine; LOGO will, in certain
circumstances, loose control to
the p-Code card, destroying what
you were doing with LOGO.  If
your p-Code card has an on/off
switch, all will be well if you
turn the card off before using
LOGO.



When a 99/4 is powered up with
the p-Code card is in place (and
turned on) the p-System
initializes and then displays
the p-System greeting. The
p-System remains active until
the user stops it; thereafter it
will not restart without using
the technique below (or turning
off the system). To get from the
the p-System to the BASIC
environment is simple - use the
p-System 'H' command.  To go
from BASIC to the p-System, you
need to have one of the
following cartridges in place on
the console:

.IN +15
1. Extended BASIC

2. Editor/Assembler

3. Mini Memory



.IN +0
From console or Extended basic,
execute the following command:

.CE

CALL LOAD(14586,0,0)



and then type fctn-= (Quit) or
the BASIC command 'BYE'. The
p-System will then operate as if
you had turned the system off
and then on again. Some programs
and cartridges seem to have the
same effect as the CALL LOAD
listed above. Exiting TI-WRITER,
MULTIPLAN, or the COMPANION word
processor will lead to restart
of the p-System. Likewise, some
of the commands in the DISK
MANAGER will reset the p-System
so that it will become active
again upon leaving this module.




Speed is an issue of interest to
all potential users of the
p-System. If computing speed is
the reason for the TI BASIC
programmer to consider the
p-System, the following
facts apply:  Because the
p-System is interpreted, it is
relatively slow compared to
compiled PASCALs (such as TURBO
PASCAL on MsDOS and CP/M
systems). Compared to other
machines, the p-System on the
99/4 is quite slow - I believe
it is the slowest implementation
of the p-System around.  TI
BASIC, however, can be
benchmarked with a sundial, so
it is easy for the p-System to
beat. Number crunching programs
PASCAL can run up to 60 times
faster than their BASIC
counterparts, especially if put
in RAM (see SETLTYPE). Programs
doing mostly screen I/O can be
slower than BASIC, however. Disk
I/O seems a little faster with
the p-System -- perhaps because
of the simpler file system,
leading to less searches for the
next block, etc. I have no
experience with FORTH, but know
that it too is faster than
BASIC. The programmer desiring
speed above all else should
compare the p-System to FORTH.



On running the V command in the
FILER program, you will notice
that there is a device #14
called 'OS:'. If you do not have
a disk in drive one (the usual
root device), one will find that
the 'PREFIX' and 'ROOT' devices
are defined as 'OS'. This device
includes files that are in ROM
and are used for booting the
system. You can read and examine
these files but not, of course,
modify them. To change the
PREFIX definition, use the FILER
P command; to change the ROOT
definition you must use the
system I (warm start) command.





.CE 2

Compatibility with other
Machines


The p-System on the 99/4 is very
compatible with other p-System
implementations. Source code
developed on the 99/4 can and
does run without modification on
most other machines if you avoid
using the TEXAS INSTRUMENTS
UNITS included with the PASCAL
Compiler. The 99/4 is less able
to run programs from other
machines due to it's relatively
small RAM size. If the program
is properly segmented, however,
there will be no problem. The
PASCAL compiler, for instance,
is 99 blocks long -- 49.5K. It
runs on the 99/4 (with a lot of
disk swapping). The only other
problem in running program from
other machines on the TI is the
presence of a 40 (rather than
80) column display. The TI will
display all 80 columns with the
SCREEN RIGHT and LEFT keys, but
you will probably want to modify
the display (if possible) to fit
the screen. In the file
SCREENOPS.CODE on device #14
(see above) is a description of
the TI screen size. This file
can be read by a program. This
file tells the program in the
case of the TI that the screen
is 40 columns. Clever programs
will adapt themselves to the
size of the screen.



A larger problem is physically
transferring programs to and
from the 99/4a. The TI p-System
lacks any functional
communications program at this
time. Files can be exported from
the 99/4a easily by using the
FILER to T)ranfer to REMOUT:.  



There is good but not complete
compatibility with other
PASCALs. I have programs that I
wrote on the TI p-System that
I ported to an MSDOS (IBM PC or
compatible) machines and
converted to TURBO PASCAL.
Little modification was
necessary.  %%%%anybody have
experience with other
pascals?%%%%%





.CE
Software for the TI p-System




I know of no commercial software
for the TI p-System. I suspect
that if enough interest could be
shown, then the whole spectrum
of existing p-System software
would be made available.



USUS maintains a large library
of programs, most of which are
not machine dependent. These
volumes are available to USUS
members for a small fee - in TI
format. Most programs have not
been modified to run on the TI.
If you modify a USUS program to
run on the 99/4, you are
requested to send a copy back to
the USUS TI distributor.




.CE

Wish List



The p-System on the TI 99/4a is
powerful but remains largely
undeveloped. What follows are
my sugestions for software
development which would greatly
aid the use of the system.



FORTRAN: could someone port this
compiler to the TI? There would
surely be great interest in this
language on the 99/4. Likewise,
many would welcome MODULA-2.



Terminal Emulation: There have
been programmers who have had TE
programs "almost working". This
is probably the highest priority
for the p-System. A TE program
would allow porting of other
programs to the TI without
re-keying the source code.



A good Data Base: there are no
high quality data base programs
available for the 99 in any
form. Several excellent programs
are available on the p-System.
Could one be ported to the 99?





.CE

HELP!



The information in this guide is
essentially all from my own
meager experiences. Like most
p-System users on the 99/4a, I
doubt that I have ever laid eyes
on anther user. This guide has
been written, therefore, in a
vacuum. Its purpose is to
catalyze discussion, debate, and
the creation of a better guide
to the TI p-System.



To improve on this guide, I need
the experiences of other users,
both the sophisticated and the
novice. 



This guide could be improved
with the following information:
Is there anybody out there who
can help with machine language
programming on the system? How
about how to change character
sets? Anybody have any
suggestions or other tricks for
use of the p-System? I solict
your comments, suggestions, and
criticisms. If you feel the
urge, trash this guide and write
your own. We all will benefit by
the interchange of information
and ideas.

 
UUUUUUUUUUU
                                                                                                                               
