/* HEADER FILE. This file contains the headers of all functional parts
   of the emulator, including all global variables. */

#define GROM_MEMSIZE 0xFFFF
#define CPU_MEMSIZE 0xFFFF
#define VDP_MEMSIZE 0x4000

typedef unsigned short int word;
typedef unsigned long  int longword;
typedef unsigned char byte;

/* boot.h */

void load_roms(char[]);
void load_byte_memory_from_file(byte *,word,char[],word,word);
void load_word_memory_from_file(word *,word,char[],word,word);

/* grom.h */

void init_grom(void);		/* nescessary initialisations */
word grom_read(word);		/* returns databyte as MSbyte of a word.
				   argument is >9C02 or >9C00 */
void grom_write(word,word);     /* writes MSbyte from word to adress */
word GromAddressCounter=0;      /* The address counter */
byte *grom;			/* The grom memory pointer */

/* memory.h */

void init_cpu(void);
word memory_read(word);		/* read a 16-bit word from memory */
void memory_write(word,word);	/* write a 16-bit word to memory  */
void vdp_interrupt(void);	/* do some nescessary incs & decs */

word 	*mem,			/* CPU memory pointer */
	paging=0;		/* 7000-7FFF paging enable flag */

/* kscan.h */

void KSCAN(void);

/* operands.h */

word	SourceOpAdr,	/* address in memory of source operand */
	SourceVal,	/* contents of source operand */
	DestOpAdr,	/* address in memory of destination operand */
	DestVal;	/* value of destination operand */

void typeIoperands(void);
void typeIIIoperands(void);
void typeIVoperands(void);
void typeVoperands(void);
void typeVIoperands(void);
void typeVIIoperands(void);
void typeVIIIoperands(void);
void typeIXoperands(void);
void typeXoperands(void);
void get_source_operand(void);
void get_dest_operand(void);
word add(word,word);

/* processor.h */

#define TRUE  1
#define FALSE 0

#define R0  WP
#define R11 WP+22
#define R12 WP+24
#define R13 WP+26
#define R14 WP+28
#define R15 WP+30

#define CURSOR_SPEED 8

void do_jump(void);

word 	WP,	/* Workspace pointer */
	PC,	/* Program counter */
	STATUS, /* Status register (16 bits) */
	IR,     /* Instruction register */

	LGT,AGT,EQ,CY,OV,OP,X,IMASK;	/* the bits in the status reg. */

/* status.h */

void set_status(word);
void get_status(void);
void set_parity(word);
void compare(word,word);

/* vdp.h */

#define DEFAULT_VDP_STATUS 	00

void init_vdp(void);		/* clear screen 		*/
word vdp_read(word);            /* read data or status 		*/
void vdp_write(word,word);	/* write address or data 	*/
void update_crt(byte);		/* write char to screen 	*/
void vdp_write_to_register(word);	/* change register (dummy) */

word VdpAddressCounter=0;	/* Vdp address counter */
byte *vdp;			/* Vdp memory */
word CRT_ROWS,CRT_COLS,CRT_SIZE;

/* DSK1.H */

void DISK(void);
void DISK_ERROR(word,word);

/* SOUND.H */

void sound_access(word);
void sound_handler(void);
byte soundbyte(word);
