/* System dependent functions. Change this file if the code should be
   ported to a different type of machine.
*/

#include <conio.h>
#include <dos.h>

void no_interrupts(void);		/* disable interrupts */
void wait_for_keypress(void);		/* wait for keyboard hit */
void clear_screen(void);		/* clear the screen */
void goto_xy(int x,int y);		/* move cursor to (x,y) */
void print_at(int x,int y,int code);	/* print code at (x,y)	*/
int current_xpos(void);			/* returns x of cursorpos */
int current_ypos(void);			/* returns y of cursorpos */
void mysound(word);			/* sound chip emulation */

#define BINARY_READ_MODE "r+b"	/* DOS type binary read */
#define KBHIT kbhit()
#define GETKEY getch()

void no_interrupts(void)
{
	disable();
}

void wait_for_keypress(void)
{
	while(!KBHIT);
}

void clear_screen(void)
{
	clrscr();
}

void goto_xy(int x,int y)
{
	gotoxy(x,y);
}

void print_at(int x,int y,int c)
{
	gotoxy(x,y);
	putch(c);
}

int current_xpos(void)
{
	return(wherex());
}

int current_ypos(void)
{
	return(wherey());
}

my_sound(word freq)
{
	sound(freq);
	delay(500);
	nosound();
}