/* This part provides the status register handling */

#define SIGN 0x8000

void set_status(word value)
{
	EQ=(value==0);
	LGT=!EQ;
	AGT=LGT && (!(value&SIGN));
}


void get_status(void)
{
	STATUS=(LGT<<15)|(AGT<<14)|(EQ<<13)|(CY<<12)|
		(OV<<11)|(OP<<10)|(X<<9)|(IMASK&0xf);
}

void set_parity(word value) /* copyright by T. Brouwer! */
{
#define PARCHECK 0x6996

	OP=(	(PARCHECK >> (value>>12)) ^
		( PARCHECK >> ((value>>8)&15) )	)&1;
}

void compare(word source,word dest)
{
	LGT=(source>dest);
	EQ=(source==dest);
	AGT=((signed int)source>(signed int)dest);
}

word add(word a, word b)
{
	word c;
	c=a+b;
	CY=(((a&b)&SIGN)!=0) || (((a&SIGN) != (b&SIGN)) &&((c&SIGN)==0));
	OV=((~a&~b&c&SIGN) || (a&b&~c&SIGN))!=0;
	return(c);
}

