/* This part provides the operands for the different types of opcodes.
   The operand values are returned via globals defined in TI99EMUL.H
*/


#define BYTE_OPERATION IR&0x1000

void typeIoperands(void)
{
	get_source_operand();
	get_dest_operand();
	if (!(BYTE_OPERATION))
		{ SourceOpAdr&=0xFFFE; DestOpAdr&=0xFFFE; }
	SourceVal=memory_read(SourceOpAdr);
        DestVal=memory_read(DestOpAdr);
}

void typeIIIoperands(void)
{
	get_source_operand();
	SourceVal=memory_read(SourceOpAdr&0xFFFE);
	DestOpAdr=WP+((IR>>5)&0x1e);
	DestVal=memory_read(DestOpAdr);
}

void typeIVoperands(void)
{
	get_source_operand();
	SourceVal=memory_read(SourceOpAdr&=0xFFFE);
	DestVal=(IR>>6)&0xF;
}

void typeVoperands(void)
{
	SourceOpAdr=WP+((IR&0xF)<<1);
	SourceVal=memory_read(SourceOpAdr);
	DestVal=(IR>>4)&0xF;
	if (!DestVal)
	{
		DestVal=memory_read(WP)&0xF;
		if (!DestVal) DestVal=16;
	}
}

void typeVIoperands(void)
{
	get_source_operand();
	SourceVal=memory_read(SourceOpAdr&=0xFFFE);
}

void typeVIIIoperands(void)
{
	SourceOpAdr=WP+((IR&0xF)<<1);
	SourceVal=memory_read(SourceOpAdr);
	DestVal=memory_read(PC);
	PC+=2;
}

void typeIXoperands(void)
{
	SourceOpAdr=WP+((IR&0xF)<<1);
}

void typeXoperands(void)
{
	SourceVal=memory_read(PC);
	PC+=2;
}

void get_source_operand(void)
{
	switch((IR>>4)&3)
	{
	case 0: 	SourceOpAdr=WP+((IR&0xF)<<1); /* Register direct */
			break;
	case 1: 	SourceOpAdr=memory_read(WP+((IR&0xF)<<1));
			break;
	case 2: 	SourceOpAdr=memory_read(PC); PC+=2;
			if (IR&0xF) SourceOpAdr+=memory_read(WP+((IR&0xF)<<1));
			break;
	case 3:		SourceOpAdr=memory_read(WP+((IR&0xF)<<1));
			memory_write(WP+((IR&0xF)<<1),SourceOpAdr+
			((BYTE_OPERATION) ? 1:2));
			break;
	}
}

void get_dest_operand(void)
{
	switch((IR>>10)&3)
	{
	case 0: 	DestOpAdr=WP+((IR>>5)&0x1E); /* Register direct */
			break;
	case 1: 	DestOpAdr=memory_read(WP+((IR>>5)&0x1E));
			break;
	case 2: 	DestOpAdr=memory_read(PC); PC+=2;
			if (IR&0x3c0) DestOpAdr+=memory_read(WP+((IR>>5)&0x1E));
			break;
	case 3: 	DestOpAdr=memory_read(WP+((IR>>5)&0x1E));
			memory_write(WP+((IR>>5)&0x1E),
			DestOpAdr+((BYTE_OPERATION) ? 1:2));
			break;
	}
}
