/* DISK emulation */

void DISK(void)
{
	word i,		/* dummy */
	dsrnamelength,	/* length of the DSR name (len(DSK1)=4) */
	filenameptr,	/* left pointing after the DSR name (on the dot) */
	startofpab,	/* VDP address of the PAB */
	filenamelength,	/* length of the name specified after the dot */
	opcode,		/* I/O opcode (PAB byte 0) */
	vdpbufferaddress,	/* read/write VDP buffer (PAB bytes 2,3) */
	length;		/* save file size or max. load file size */

	static int row=1;

	char filename[13];

	if ((PC<0x4000)||(PC>0x41FF)) ILL();

	memory_write(0x837C,memory_read(0x837C)&0xff);
	dsrnamelength=memory_read(0x8354);
	filenameptr=memory_read(0x8356);
	startofpab=filenameptr-dsrnamelength-10;
	filenamelength=*(vdp+startofpab+9)-dsrnamelength-1;

	/* decode filename from the PAB into DOS file name */

	if ((filenamelength<1)||(filenamelength>8))
	{
		DISK_ERROR(startofpab,7);
		return;
	}
	for(i=0;i<filenamelength;i++)
	filename[i]=toupper(*(vdp+filenameptr+i+1));
	filename[i]=0;
	strcat(filename,".TI");

	opcode=*(vdp+startofpab);

	gotoxy(42,row++);
	row=((row-1)%24)+1;
	cprintf("Opcode %d, name: %s",opcode,filename);

	vdpbufferaddress=((*(vdp+startofpab+2)<<8)+*(vdp+startofpab+3))&0x3fff;
	length=(*(vdp+startofpab+6)<<8)+*(vdp+startofpab+7);
	if (length==0)
	{
		DISK_ERROR(startofpab,7);
		return;
	}
	if (vdpbufferaddress+length>0x4000) length=0x4000-vdpbufferaddress;

	switch(opcode)
	{
	case 1:
	{
		DISK_ERROR(startofpab,0);
		return;
	}
	case 5:
	{
		FILE *infile;

		/* Open file for read and check result */

		infile=fopen(filename,"rb");
		if (infile==NULL)
		{
			DISK_ERROR(startofpab,7);
			return;
		}

		/* Check for "TIFILES" header and skip it if present */

		if (fgetc(infile)==7) /* Tifiles header byte */
		{
			char test[9];
			fgets(test,8,infile);
			if (!strcmp(test,"TIFILES"))
				for(i=8;i<128;i++) fgetc(infile);
		}
		else rewind(infile);

		/* Load file until eof or max length is reached */

		i=0;
		while((!feof(infile))&&(i<length))
			*(vdp+vdpbufferaddress+i++)=fgetc(infile);

		/* Close file and report no errors */

		fclose(infile);
		DISK_ERROR(startofpab,0);
		break;
	}

	case 6:
	{
		FILE *outfile;
		outfile=fopen(filename,"wb");
		if (outfile==NULL)
		{
			DISK_ERROR(startofpab,6);
			return;
		}

		/* First output TIFILES header */

		{
		word NS,LB;
		NS=(word)length/256;	/* number of sectors */
		LB=(word)length%256;	/* EOF pointer in last sector */
		if (LB) NS++;		/* count last sector */
		fprintf(outfile,"%c%s",7,"TIFILES");
		fprintf(outfile,"%c%c%c%c%c",NS/256,NS%256,1,0,LB,0);
		for(i=13;i<128;i++) fputc(0,outfile);
		}

		/* SAVE data from VDP */

		for(i=0;i<length;i++) fputc(*(vdp+vdpbufferaddress+i),outfile);
		fclose(outfile);
		DISK_ERROR(startofpab,0);
		break;
	}

	default: DISK_ERROR(startofpab,3);
	}
}

void DISK_ERROR(word pab,word errno)
{
	*(vdp+pab+1)=(*(vdp+pab+1)&0x1f)|((errno&7)<<5);
}


