/*--------------------------------------------------------
   STATUS.C -- StatusBar Implemention for MSX for Windows
                 (c) The Prodigy, 1995
  --------------------------------------------------------*/

#include <windows.h>
#include <string.h>
#include "resource.h"
#include "msx.h"

static void NEAR InitStatBar () ;
static void NEAR PaintStatBar (HWND, HDC) ;
extern HINSTANCE	g_hInstance ;
extern BOOL		g_bPrint, g_bCaps ;

HWND			g_hwndStat ;
UINT			g_idStatText ;
static const char BASED_CODE szPrint[] = "PRINT" ;
static const char BASED_CODE szCaps[]  = "CAPS" ;

// Statbar paint helper structure
typedef struct
	{
	int		dyBorder ;		// System Border Width/Height
	int		dyBorderx2 ;		// System Border Width/Height * 2
	int		dyBorderx3 ;		// System Border Width/Height * 3
	int		dyBorderx6 ;		// System Border Width/Height * 6
	int		dyBorderx8 ;		// System Border Width/Height * 8
	int		dyStatbar ;		// Status Bar height
	int		dxCaps ;			// Width reserved for caps Info
	int		dxPrint ;			// Width reserved for slow Info
	HFONT	hFont ;			// Font used in status bar
	} STATUSPAINT ;

STATUSPAINT StatbarPntData ;

long FAR PASCAL _export StatusWndProc (HWND hwnd, UINT message, UINT wParam,
											LONG lParam)
	{
	PAINTSTRUCT	ps ;
	
	switch (message)
		{
		case WM_CREATE:
			InitStatBar () ;
			
			return 0 ;
			
		case WM_PAINT:
			BeginPaint (hwnd, &ps) ;

			PaintStatBar (hwnd, ps.hdc) ;

			EndPaint (hwnd, &ps) ;
			
			return 0 ;
			
		case WM_DESTROY:
			DeleteObject (StatbarPntData.hFont) ;
			
			return 0 ;
		}
	
	return DefWindowProc (hwnd, message, wParam, lParam) ;
	}

void FAR SetStatTextID (UINT id)
	{
	RECT		rc ;
	HDC		hdc ;
	HFONT	hOldFont ;
	char		szBuf[256] ;
	
	if (id != g_idStatText)
		{
		g_idStatText = id ;
		if (id)
			LoadString (g_hInstance, id, szBuf, 256) ;
		else
			szBuf[0]= 0 ;
		
		GetClientRect (g_hwndStat, &rc) ;
		hdc = GetDC (g_hwndStat) ;
		hOldFont = SelectObject (hdc, StatbarPntData.hFont) ;
		SetTextColor (hdc, GetSysColor (COLOR_BTNTEXT) ) ;
		SetBkColor (hdc, GetSysColor (COLOR_BTNFACE) ) ;
		
		rc.top += StatbarPntData.dyBorder * 4 ;
		rc.bottom -= StatbarPntData.dyBorderx3 ;
		rc.left += StatbarPntData.dyBorder * 9 ;
		rc.right -= StatbarPntData.dyBorder * 21 + StatbarPntData.dxCaps + StatbarPntData.dxPrint ;
		
		ExtTextOut (hdc, rc.left + StatbarPntData.dyBorder, 
			rc.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, 
			&rc, szBuf, strlen (szBuf), NULL ) ;
		
		SelectObject (hdc, hOldFont) ;
		ReleaseDC (g_hwndStat, hdc) ;
		}
	}

void SetIndicators ()
	{
	RECT		rc ;
	HDC		hdc ;
	HFONT	hOldFont ;
	
	static BOOL bOldPrint, bOldCaps ;
	
	if (bOldPrint != g_bPrint || bOldCaps != g_bCaps)
		{
		hdc = GetDC (g_hwndStat) ;
		hOldFont = SelectObject (hdc, StatbarPntData.hFont) ;
		SetBkColor (hdc, GetSysColor (COLOR_BTNFACE) ) ;
		
		GetClientRect (g_hwndStat, &rc) ;
		rc.top = rc.top + StatbarPntData.dyBorder * 4 ;
		rc.bottom = rc.bottom - StatbarPntData.dyBorderx3 ;
		
		// caps pane
		rc.right = rc.right - StatbarPntData.dyBorderx8 ;
		rc.left = rc.right - StatbarPntData.dxCaps + StatbarPntData.dyBorder ;
		
		if (bOldCaps != g_bCaps)
			{
			SetTextColor (hdc, GetSysColor (g_bCaps ? COLOR_BTNTEXT : COLOR_BTNSHADOW) ) ;
			ExtTextOut (hdc, rc.left + StatbarPntData.dyBorder, 
				rc.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, &rc, 
				szCaps, sizeof (szCaps) - 1, NULL ) ;
			bOldCaps = g_bCaps ;
			}
		
		// print pane
		rc.right = rc.left - StatbarPntData.dyBorderx8 ;
		rc.left = rc.right - StatbarPntData.dxPrint + StatbarPntData.dyBorderx2 ;
		
		if (bOldPrint != g_bPrint)
			{
			SetTextColor (hdc, GetSysColor (g_bPrint ? COLOR_BTNTEXT : COLOR_BTNSHADOW) ) ;
			ExtTextOut (hdc, rc.left + StatbarPntData.dyBorder, 
				rc.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, &rc, 
				szPrint, sizeof (szPrint) - 1, NULL ) ;
			bOldPrint = g_bPrint ;
			}
		
		ReleaseDC (g_hwndStat, hdc) ;
		}
	}

static void NEAR InitStatBar ()
	{
	HDC			hDC ;
	TEXTMETRIC	tm ;
	HFONT		hOldFont ;
	LOGFONT		lFont ;

	StatbarPntData.dyBorder   = GetSystemMetrics (SM_CYBORDER) ;
	StatbarPntData.dyBorderx2 = StatbarPntData.dyBorder * 2 ;
	StatbarPntData.dyBorderx3 = StatbarPntData.dyBorder * 3 ;
	StatbarPntData.dyBorderx6 = StatbarPntData.dyBorder * 6 ;
	StatbarPntData.dyBorderx8 = StatbarPntData.dyBorder * 8 ;

	hDC = GetDC (NULL);
	
	GetObject (GetStockObject (ANSI_VAR_FONT),  sizeof (LOGFONT), &lFont) ;
	lFont.lfWeight = FW_NORMAL ;
	StatbarPntData.hFont = CreateFontIndirect (&lFont) ;
	
	hOldFont = SelectObject (hDC, StatbarPntData.hFont);
	
	GetTextMetrics (hDC, &tm) ;
	
	StatbarPntData.dyStatbar = tm.tmHeight + tm.tmExternalLeading + 7 * StatbarPntData.dyBorder ;
	StatbarPntData.dxPrint   = LOWORD (GetTextExtent (hDC, szPrint, sizeof (szPrint) - 1) ) + 
		StatbarPntData.dyBorder * 4 ;
	StatbarPntData.dxCaps    = LOWORD (GetTextExtent (hDC, szCaps, sizeof (szCaps) - 1) ) + 
		StatbarPntData.dyBorder * 4 ;
	
	SelectObject (hDC, hOldFont) ;
	ReleaseDC (NULL, hDC) ;
	}

static void NEAR PaintStatBar (HWND hwnd, HDC hdc)
	{
	RECT		rc, rcTemp ;
	HBRUSH	hbr ;
	HFONT	hOldFont ;
	char		szBuf[256] ;
	
	GetClientRect (hwnd, &rc) ;
	
	// draw the frame
	hbr = CreateSolidBrush (GetSysColor (COLOR_BTNSHADOW) ) ;
	
	// top
	rcTemp = rc ;
	rcTemp.top += StatbarPntData.dyBorderx2 ;
	rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder ;
	
	rcTemp.right -= StatbarPntData.dyBorderx8 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxCaps ;
	FillRect (hdc, &rcTemp, hbr) ;
		
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx6 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxPrint ;
	FillRect (hdc, &rcTemp, hbr) ;
		
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx6 ;
	rcTemp.left = rc.left + StatbarPntData.dyBorderx8 ;
	FillRect (hdc, &rcTemp, hbr) ;
		
	// left
	rcTemp = rc ;
	rcTemp.top += StatbarPntData.dyBorderx2 ;
	rcTemp.bottom -= StatbarPntData.dyBorderx2 ;
	
	rcTemp.left = rcTemp.right - StatbarPntData.dyBorderx8 - StatbarPntData.dxCaps ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	rcTemp.left -= StatbarPntData.dyBorderx6 + StatbarPntData.dxPrint ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	rcTemp.left = rc.left + StatbarPntData.dyBorderx8 ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	DeleteObject (hbr) ;
	hbr = CreateSolidBrush (GetSysColor (COLOR_BTNHIGHLIGHT) ) ;
	
	// bottom
	rcTemp = rc ;
	rcTemp.top = rcTemp.bottom - StatbarPntData.dyBorderx2 ;
	rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder ;
	
	rcTemp.right -= StatbarPntData.dyBorderx8 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxCaps ;
	FillRect (hdc, &rcTemp, hbr) ;
		
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx6 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxPrint ;
	FillRect (hdc, &rcTemp, hbr) ;
		
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx6 ;
	rcTemp.left = rc.left + StatbarPntData.dyBorderx8 ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	// right
	rcTemp = rc ;
	rcTemp.top += StatbarPntData.dyBorderx2 ;
	rcTemp.bottom -= StatbarPntData.dyBorderx2 ;
	
	rcTemp.left = rcTemp.right - StatbarPntData.dyBorderx8 ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	rcTemp.left -= StatbarPntData.dyBorderx6 + StatbarPntData.dxCaps ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	rcTemp.left -= StatbarPntData.dyBorderx6 + StatbarPntData.dxPrint ;
	rcTemp.right = rcTemp.left + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	// line across top
	rcTemp = rc ;
	rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder ;
	FillRect (hdc, &rcTemp, hbr) ;
	
	DeleteObject (hbr) ;
	
	// text
	hOldFont = SelectObject (hdc, StatbarPntData.hFont) ;
	SetBkColor (hdc, GetSysColor (COLOR_BTNFACE) ) ;
	
	rcTemp.top = rc.top + StatbarPntData.dyBorder * 4 ;
	rcTemp.bottom = rc.bottom - StatbarPntData.dyBorderx3 ;
	
	// caps pane
	rcTemp.right = rc.right - StatbarPntData.dyBorderx8 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxCaps + StatbarPntData.dyBorder ;
	
	SetTextColor (hdc, GetSysColor (g_bCaps ? COLOR_BTNTEXT : COLOR_BTNSHADOW) ) ;
	ExtTextOut (hdc, rcTemp.left + StatbarPntData.dyBorder, 
		rcTemp.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, &rcTemp, 
		szCaps, sizeof (szCaps) - 1, NULL ) ;
	
	// print pane
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx8 ;
	rcTemp.left = rcTemp.right - StatbarPntData.dxPrint + StatbarPntData.dyBorderx2 ;
	
	SetTextColor (hdc, GetSysColor (g_bPrint ? COLOR_BTNTEXT : COLOR_BTNSHADOW) ) ;
	ExtTextOut (hdc, rcTemp.left + StatbarPntData.dyBorder, 
		rcTemp.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, &rcTemp, 
		szPrint, sizeof (szPrint) - 1, NULL ) ;
	
	// info pane text
	rcTemp.right = rcTemp.left - StatbarPntData.dyBorderx8 ;
	rcTemp.left = rc.left + StatbarPntData.dyBorder * 9 ;
	
	if (g_idStatText)
		LoadString (g_hInstance, g_idStatText, szBuf, 256) ;
	else
		szBuf[0] = '\0' ;
	
	SetTextColor (hdc, GetSysColor (COLOR_BTNTEXT) ) ;
	ExtTextOut (hdc, rcTemp.left + StatbarPntData.dyBorder, 
		rcTemp.top - StatbarPntData.dyBorder, ETO_OPAQUE | ETO_CLIPPED, 
		&rcTemp, szBuf, strlen (szBuf), NULL ) ;
	
	SelectObject  (hdc, hOldFont) ;
	}
