// disk.c
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <cderr.h>
#include <string.h>
#include <stdlib.h>
#include "resource.h"
#include "msx.h"
#include "mem.h"
#include "document.h"
#include "msxcore.h"
#include "dialogs.h"

// *sigh*
#ifdef _WINDOWS
  #undef _WINDOWS
    #include <bios.h>
  #define _WINDOWS
#else
  #include <bios.h>
#endif
// end-of-sigh...*sigh*

extern char		g_szDiskAFile[], g_szDiskBFile[] ;
extern const char	g_szAppName[] ;
extern BOOL		g_bDriveA, g_bDriveB ;
extern HANDLE		g_hInstance ;
extern HWND		g_hwndMain ;
extern FILESETTINGS	g_fileset, DefSet ;
extern BOOL		g_bNeedSave, g_bPalette ;

BOOL CreateDSKfile (BOOL, char*) ;
int WriteSector (int, LPBYTE, int, int, BYTE) ;
int ReadSector (int, LPBYTE, int, int, BYTE) ;
static BOOL NEAR CheckDSKfile (HWND, char*, BOOL) ;

static char	*szCreatFile ;
static const char 
	BASED_CODE g_sz360Kb[] = "3.5\" 1DD (360Kb)", 
	BASED_CODE g_sz720Kb[] = "3.5\" 2DD (720Kb)", 
	BASED_CODE g_szDriveNone[] = "(none)", 
	BASED_CODE g_szDriveA[] = "Drive A:", 
	BASED_CODE g_szDriveB[] = "Drive B:", 
	BASED_CODE g_szFilter[] = "Disk Files (*.dsk)\0*.dsk\0"
		"All Files (*.*)\0*.*\0", 
	BASED_CODE g_szDefExt[] = "dsk", 
	BASED_CODE g_szTitle[] = "Browse" ;

static BOOL NEAR DSKBrowse (HWND hDlg, char *szFile, BOOL bExist)
	{
	OPENFILENAME	ofn ;
	
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = hDlg ;
	ofn.lpstrFilter = g_szFilter ;
	ofn.lpstrFile   = szFile ;
	ofn.nMaxFile    = _MAX_PATH ;
	ofn.lpstrTitle  = g_szTitle ;
	if (bExist)
		ofn.Flags       = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT ;
	else
		ofn.Flags       = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT ;
	ofn.lpstrDefExt = g_szDefExt ;
	
	if (!GetOpenFileName (&ofn) )
		{
		if (CommDlgExtendedError () == FNERR_INVALIDFILENAME)
			{
			szFile[0] = '\0' ;
			return (GetOpenFileName (&ofn) && CheckDSKfile (hDlg, szFile, bExist) ) ;
			}
		
		return FALSE ;
		}
	
	return CheckDSKfile (hDlg, szFile, bExist) ;
	}

static BOOL NEAR DSKBrowseNoChk (HWND hDlg, char *szFile)
	{
	OPENFILENAME	ofn ;
	
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = hDlg ;
	ofn.lpstrFilter = g_szFilter ;
	ofn.lpstrFile   = szFile ;
	ofn.nMaxFile    = _MAX_PATH ;
	ofn.lpstrTitle  = g_szTitle ;
	ofn.Flags       = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT ;
	ofn.lpstrDefExt = g_szDefExt ;
	
	if (!GetOpenFileName (&ofn) )
		{
		if (CommDlgExtendedError () == FNERR_INVALIDFILENAME)
			{
			szFile[0] = '\0' ;
			return GetOpenFileName (&ofn) ;
			}
		
		return FALSE ;
		}
	
	return TRUE ;
	}

static void NEAR FileErr (UINT nErr, HWND hDlg, char *szFile)
	{
	char		szBuf[256], szBuf2[_MAX_PATH] ;
	
	LoadString (g_hInstance, nErr, szBuf, 256) ;
	wsprintf (szBuf2, szBuf, (LPSTR)szFile) ;
	MessageBox (hDlg, szBuf2, g_szAppName, MB_ICONEXCLAMATION) ;
	}

static void NEAR BootSector (HWND hDlg, int drive, BOOL b720)
	{
	HGLOBAL	hglb ;
	int		i ;
	
	hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
		MAKEINTRESOURCE (b720 ? IDSEC_2DD : IDSEC_1DD), "SEC") ) ;
	
	i = WriteSector (drive, LockResource (hglb), 0, 1, '\0') ;
	
	switch (i)
		{
		case -1:
			break ;
		
		case 0:
			i = IDS_DISKPROT ;
			break ;
		
		case 2:
			i = IDS_DISKNOTREADY ;
			break ;
		
		default:
			i = IDS_DISKWRITEERR ;
			break ;
		}
	
	if (i != -1)
		MessageID (hDlg, i, MB_ICONEXCLAMATION) ;
	
	UnlockResource (hglb) ;
	FreeResource (hglb) ;
	}

static void NEAR FileBootSector (HWND hDlg, char *szFile, BOOL b720)
	{
	HGLOBAL	hglb ;
	BYTE		by ;
	OFSTRUCT	of ;
	long		lSize ;
	HFILE	hFile ;
	
	hFile = OpenFile (szFile, &of, OF_READWRITE) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, hDlg, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, hDlg, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				break ;
			}
		
		return ;
		}
	
	if (1 != _lread (hFile, &by, 1) )
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				
		return ;
		}
	
	lSize = _llseek (hFile, 0L, 2) ;
	
	if ( (by != 0xeb && by != 0xe9) || 
		(lSize != 720L * 1024L && lSize != 360L * 1024L) )
		{
		_lclose (hFile) ;
		
		FileErr (IDS_FILEDSK, hDlg, szFile) ;
		
		return ;
		}
	
	_llseek (hFile, 0L, 0) ;
	
	hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
		MAKEINTRESOURCE (b720 ? IDSEC_2DD : IDSEC_1DD), "SEC") ) ;
	
	if (512 != _lwrite (hFile, LockResource (hglb), 512) )
		FileErr (IDS_FILEWRITEUNEXPECT, hDlg, szFile) ;
	
	UnlockResource (hglb) ;
	FreeResource (hglb) ;
		
	_lclose (hFile) ;
	}

// MSX Bootsector Dialog box
BOOL FAR PASCAL _export BootSectorDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char		szFile[_MAX_PATH] ;
	int		i ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// disk size
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz360Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz720Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_SETCURSEL, 1, 0L) ;
			
			// real drive
			if (!g_bDriveA && !g_bDriveB)
				{
				EnableWindow (GetDlgItem (hDlg, IDC_DRVCMB), FALSE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_REALRAD), FALSE) ;
				
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveNone) ;
				}
			
			if (g_bDriveA)
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
			if (g_bDriveB)
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
			SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_SETCURSEL, 0, 0L) ;
			
			SendDlgItemMessage (hDlg, IDC_REALRAD, BM_SETCHECK, 1, 0L) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
					i = (int)SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_GETCURSEL, 0, 0L) ;
					
					if (SendDlgItemMessage (hDlg, IDC_REALRAD, BM_GETCHECK, 0, 0L) )
						{
						BootSector (hDlg, (int)SendDlgItemMessage (hDlg, IDC_DRVCMB, 
							CB_GETCURSEL, 0, 0L), i) ;
						}
					else
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile, sizeof (szFile) ) ;
						if (szFile[0])
							{
							FileBootSector (hDlg, szFile, i) ;
							}
						else
							{
							MessageID (hDlg, IDS_TYPEFILE, MB_ICONEXCLAMATION) ;
							
						     return TRUE ;
						     }
						}
					
				case IDCANCEL:
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_BROWSEBTN:
				case IDC_DRVCMB:
				case IDC_DISKFILEEDIT:
					SendDlgItemMessage (hDlg, IDC_DISKFILERAD, BM_SETCHECK, wParam != IDC_DRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_REALRAD, BM_SETCHECK, wParam == IDC_DRVCMB, 0L) ;
					
					if (wParam == IDC_BROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile, sizeof (szFile) ) ;
						if (DSKBrowse (hDlg, szFile, TRUE) )
							SetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

// disk setup dialog
BOOL FAR PASCAL _export CreateDSKDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	switch (message)
		{
		case WM_INITDIALOG:
			// disk size
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz360Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz720Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_SETCURSEL, 1, 0L) ;

			SetWindowText (GetDlgItem (hDlg, IDC_FILE), szCreatFile) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
					EndDialog (hDlg, CreateDSKfile (
						(int)SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_GETCURSEL, 0, 0L), 
						szCreatFile) ) ;
					
					return TRUE ;
				
				case IDCANCEL:
					EndDialog (hDlg, FALSE) ;
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

static BOOL NEAR CheckDSKfile (HWND hDlg, char *szFile, BOOL bExist)
	{
	BYTE		by ;
	OFSTRUCT	of ;
	long		lSize ;
	HFILE	hFile ;
	
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
				if (!bExist)
					{
					szCreatFile = szFile ;
					return DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_CREATDSK), 
						hDlg, CreateDSKDlgProc) ;
					}
			case 0x0003:
				FileErr (IDS_FILEREADPATH, hDlg, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, hDlg, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	if (1 != _lread (hFile, &by, 1) )
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				
		return FALSE ;
		}
	
	lSize = _llseek (hFile, 0L, 2) ;
	_lclose (hFile) ;
	
	if (lSize != 720L * 1024L && lSize != 360L * 1024L)
		{
		FileErr (IDS_FILEDSK, hDlg, szFile) ;
		
		return FALSE ;
		}
	
	if (by != 0xeb && by != 0xe9)
		FileErr (IDS_FILEDSKMAY, hDlg, szFile) ;
	
	mmioOpen (szFile, NULL, MMIO_PARSE) ;
	
	return TRUE + (lSize == 720L * 1024L) ;
	}

// disk setup dialog
BOOL FAR PASCAL _export DiskDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char		szFile1[_MAX_PATH], szFile2[_MAX_PATH] ;
	int		i ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// fill drive combo boxes
			SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR)g_szDriveNone) ;
			SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR)g_szDriveNone) ;
			if (g_bDriveA)
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
				}
			if (g_bDriveB)
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
				}
			
			SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_SETCURSEL, 
				g_fileset.nDrvA, 0L) ;
			SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_SETCURSEL, 
				g_fileset.nDrvB, 0L) ;
			
			// disk files
			SetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), g_szDiskAFile) ;
			SetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), g_szDiskBFile) ;
			
			SendDlgItemMessage (hDlg, IDC_DSKAPROTCHK, BM_SETCHECK, g_fileset.bDrvAProt, 0L) ;
			SendDlgItemMessage (hDlg, IDC_DSKBPROTCHK, BM_SETCHECK, g_fileset.bDrvBProt, 0L) ;
			
			// drive A
			SendDlgItemMessage (hDlg, g_fileset.bDrvADrv ? IDC_DRVADRVRDO : IDC_DRVADSKRDO, 
				BM_SETCHECK, 1, 0L) ;
			SendDlgItemMessage (hDlg, !g_fileset.bDrvADrv ? IDC_DRVADRVRDO : IDC_DRVADSKRDO, 
				BM_SETCHECK, 0, 0L) ;
			
			// drive B
			SendDlgItemMessage (hDlg, g_fileset.bDrvBDrv ? IDC_DRVBDRVRDO : IDC_DRVBDSKRDO, 
				BM_SETCHECK, 1, 0L) ;
			SendDlgItemMessage (hDlg, !g_fileset.bDrvBDrv ? IDC_DRVBDRVRDO : IDC_DRVBDSKRDO, 
				BM_SETCHECK, 0, 0L) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK :
					GetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1, sizeof (szFile1) ) ;
					if (szFile1[0])
						{
						if (!CheckDSKfile (hDlg, szFile1, FALSE) )
							{
							SetFocus (GetDlgItem (hDlg, IDC_DRVADSKEDIT) ) ;
							break ;
							}
						}
					GetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile2, sizeof (szFile2) ) ;
					if (szFile2[0])
						{
						if (!CheckDSKfile (hDlg, szFile2, FALSE) )
							{
							SetFocus (GetDlgItem (hDlg, IDC_DRVBDSKEDIT) ) ;
							break ;
							}
						}
					
					if (SendDlgItemMessage (hDlg, IDC_DRVADRVRDO, BM_GETCHECK, 0, 0L) )
						{
						if (SendDlgItemMessage (hDlg, IDC_DRVBDRVRDO, BM_GETCHECK, 0, 0L) )
							{
							// both disk drives
							i = (int)SendDlgItemMessage (hDlg, 
								IDC_DRVADRVCMB, CB_GETCURSEL, 0, 0L) ;
							
							if (i && i == (int) SendDlgItemMessage (hDlg, 
								IDC_DRVBDRVCMB, CB_GETCURSEL, 0, 0L) )
								{
								MessageID (hDlg, IDS_DISKSAME, MB_OK | MB_ICONEXCLAMATION) ;
								
								return TRUE ;
								}
							}
						}
					else
						{
						if (!SendDlgItemMessage (hDlg, IDC_DRVBDRVRDO, BM_GETCHECK, 0, 0L) )
							{
							// both disk files
							if (szFile1[0] && !strcmp (szFile1, szFile2) )
								{
								MessageID (hDlg, IDS_DISKSAME, MB_OK | MB_ICONEXCLAMATION) ;
								
								return TRUE ;
								}
							}
						}
					
					strcpy (g_szDiskAFile, szFile1) ;
					strcpy (g_szDiskBFile, szFile2) ;
					
					g_fileset.bDrvAProt = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DSKAPROTCHK, BM_GETCHECK, 0, 0L) ;
					g_fileset.bDrvBProt = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DSKBPROTCHK, BM_GETCHECK, 0, 0L) ;
					
					g_fileset.bDrvADrv = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DRVADRVRDO, BM_GETCHECK, 0, 0L) ;
					g_fileset.bDrvBDrv = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DRVBDRVRDO, BM_GETCHECK, 0, 0L) ;
					
					g_fileset.nDrvA = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DRVADRVCMB, CB_GETCURSEL, 0, 0L) ;
					g_fileset.nDrvB = (WORD) SendDlgItemMessage (hDlg, 
						IDC_DRVBDRVCMB, CB_GETCURSEL, 0, 0L) ;
					
					g_bNeedSave = TRUE ;
				
				case IDCANCEL :
					EndDialog (hDlg, wParam == IDOK) ;
					return TRUE ;
				
				case IDC_DRVADRVCMB:
					if (HIWORD (lParam) != CBN_SETFOCUS)
						break ;
					
				case IDC_DRVADSKEDIT:
					if (wParam == IDC_DRVADSKEDIT && HIWORD (lParam) != EN_SETFOCUS)
						break ;
					
				case IDC_DRVABROWSEBTN:
				case IDC_DSKAPROTCHK:
					SendDlgItemMessage (hDlg, IDC_DRVADRVRDO, BM_SETCHECK, wParam == IDC_DRVADRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_DRVADSKRDO, BM_SETCHECK, wParam != IDC_DRVADRVCMB, 0L) ;
					
					if (wParam == IDC_DRVABROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1, _MAX_PATH) ;
						if (DSKBrowse (hDlg, szFile1, FALSE) )
							SetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1) ;
						}
					
					return TRUE ;
				
				case IDC_DRVBDRVCMB:
					if (HIWORD (lParam) != CBN_SETFOCUS)
						break ;
						
				case IDC_DRVBDSKEDIT:
					if (wParam == IDC_DRVBDSKEDIT && HIWORD (lParam) != EN_SETFOCUS)
						break ;
					
				case IDC_DRVBBROWSEBTN:
				case IDC_DSKBPROTCHK:
					SendDlgItemMessage (hDlg, IDC_DRVBDRVRDO, BM_SETCHECK, wParam == IDC_DRVBDRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_DRVBDSKRDO, BM_SETCHECK, wParam != IDC_DRVBDRVCMB, 0L) ;
					
					if (wParam == IDC_DRVBBROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile1, _MAX_PATH) ;
						if (DSKBrowse (hDlg, szFile1, FALSE) )
							SetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile1) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

// copying disks
static int NEAR DiskReadErr (HWND hDlg, int nErr)
	{
	switch (nErr)
		{
		case 0x06:
		case 0x80:
		case 0xaa:
			nErr = IDS_DISKNOTREADY ;
			break ;
		
		default:
			nErr = IDS_DISKREADERR ;
			break ;
		}
	
	return MessageID (hDlg, nErr, MB_ICONEXCLAMATION | MB_RETRYCANCEL) ;
	}

static BOOL NEAR CopyDiskToFile (HWND hDlg, int drive, char *szFile, BOOL b720)
	{
	struct _diskinfo_t	diskinfo ;
	HFILE	hFile ;
	BYTE		byBuf[512*9] ;
	int		i, n, h, f, x ;
	HCURSOR	hcurOld ;
	BOOL		bBadSecCont ;
	
	if (IDCANCEL == MessageID (hDlg, IDS_DISKSOURCE, MB_OKCANCEL | MB_ICONEXCLAMATION) )
		return FALSE ;
	
	diskinfo.drive = drive ;
	
	hFile = _lcreat (szFile, 0) ;
	if (HFILE_ERROR == hFile)
		goto err1 ;
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	bBadSecCont = FALSE ;
	
	if (b720)
		{
		for (i=0;i<80;i++)
			{
			diskinfo.track = i ;
			
			for (h=0;h<2;h++)
				{
				diskinfo.head     = h ;
				diskinfo.sector   = 1 ;
				diskinfo.nsectors = 9 ;
				diskinfo.buffer = byBuf ;
retry:
				f = 0 ;
again:
				n = _bios_disk (_DISK_READ, &diskinfo) / 256 ;
				if (n && f++ < 1)
					goto again ;
				
				if (n == 0x10 || n == 0x11)
					{
					if (!bBadSecCont)
						{
						ShowCursor (FALSE) ;
						SetCursor (hcurOld) ;
						
						bBadSecCont = MessageID (hDlg, IDS_BADSECTOR, 
							MB_ICONQUESTION | MB_YESNO) == IDYES ;
						
						hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
						ShowCursor (TRUE) ;
						}
					
					if (bBadSecCont)
						{
						// read sector by sector
						diskinfo.nsectors = 1 ;
						
						for (x=1;x<=9;x++)
							{
							diskinfo.sector = x ;
							diskinfo.buffer = byBuf + (x - 1) * 512 ;
							
							switch (_bios_disk (_DISK_READ, &diskinfo) / 256)
								{
								case 0:
								case 0x10:
								case 0x11:
									continue ;
								
								default:
									break ;
								}
							}
						
						n = 0 ; // problem resolved
						}
					else
						goto diskerr ;
					}
				
				if (n)
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
					
					if (DiskReadErr (hDlg, n) == IDCANCEL)
						goto diskerr ;
					
					hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
					ShowCursor (TRUE) ;
					
					goto retry ;
					}
				
				if (512*9 != _lwrite (hFile, byBuf, 512*9) )
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
					
					goto err2 ;
					}
				}
			}
		}
	else
		{
		diskinfo.head = 0 ;
		
		for (i=0;i<80;i++)
			{
			diskinfo.track = i ;
			diskinfo.sector   = 1 ;
			diskinfo.nsectors = 9 ;
			diskinfo.buffer = byBuf ;
retry2:
			f = 0 ;
again2:
			n = _bios_disk (_DISK_READ, &diskinfo) / 256 ;
			if (n && f++ < 1)
				goto again2 ;
			
			if (n == 0x10 || n == 0x11)
				{
				if (!bBadSecCont)
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
						
					bBadSecCont = MessageID (hDlg, IDS_BADSECTOR, 
						MB_ICONQUESTION | MB_YESNO) == IDYES ;
						
					hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
					ShowCursor (TRUE) ;
					}
				
				if (bBadSecCont)
					{
					// read sector by sector
					diskinfo.nsectors = 1 ;
					
					for (x=1;x<=9;x++)
						{
						diskinfo.sector = x ;
						diskinfo.buffer = byBuf + (x - 1) * 512 ;
							
						switch (_bios_disk (_DISK_READ, &diskinfo) / 256)
							{
							case 0:
							case 0x10:
							case 0x11:
								continue ;
								
							default:
								break ;
							}
						}
						
					n = 0 ; // problem resolved
					}
				else
					goto diskerr ;
				}
			
			if (n)
				{
				ShowCursor (FALSE) ;
				SetCursor (hcurOld) ;
					
				if (DiskReadErr (hDlg, n) == IDCANCEL)
					goto diskerr ;
					
				hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
				ShowCursor (TRUE) ;
					
				goto retry2 ;
				}
			
			if (512*9 != _lwrite (hFile, byBuf, 512*9) )
				{
				ShowCursor (FALSE) ;
				SetCursor (hcurOld) ;
				
				goto err2 ;
				}
			}
		}
	
	_lclose (hFile) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return TRUE ;
	
err2:
	_lclose (hFile) ;
	OpenFile (szFile, NULL, OF_DELETE) ;
err1:	
	MessageID (hDlg, IDS_SAVEFAIL, MB_ICONEXCLAMATION) ;
	
	return FALSE ;

diskerr:
	_lclose (hFile) ;
	OpenFile (szFile, NULL, OF_DELETE) ;
	
	return FALSE ;
	}

static int NEAR DiskWriteErr (HWND hDlg, int nErr)
	{
	switch (nErr)
		{
		case 0x03:
			nErr = IDS_DISKPROT ;                          
			break ;
		
		case 0x06:
		case 0x80:
		case 0xaa:
			nErr = IDS_DISKNOTREADY ;
			break ;
		
		default:
			nErr = IDS_DISKWRITEERR ;
			break ;
		}
	
	return MessageID (hDlg, nErr, MB_ICONEXCLAMATION | MB_RETRYCANCEL) ;
	}

static BOOL NEAR CopyFileToDisk (HWND hDlg, int drive, char *szFile, BOOL b720)
	{
	struct _diskinfo_t	diskinfo ;
	HFILE	hFile ;
	BYTE		byBuf[512*9], by ;
	HCURSOR	hcurOld ;
	OFSTRUCT	of ;
	long		lSize ;
	int		i, n, h, x, f ;
	BOOL		bBadSecCont ;
	
	if (IDCANCEL == MessageID (hDlg, IDS_DISKDES, MB_OKCANCEL | MB_ICONEXCLAMATION) )
		return FALSE ;
	
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, hDlg, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, hDlg, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	if (1 != _lread (hFile, &by, 1) )
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				
		return FALSE ;
		}
	
	lSize = _llseek (hFile, 0L, 2) ;
	
	if (lSize != 720L * 1024L && lSize != 360L * 1024L)
		{
		_lclose (hFile) ;
		
		FileErr (IDS_FILEDSK, hDlg, szFile) ;
		
		return FALSE ;
		}
	
	if (by != 0xeb && by != 0xe9)
		MessageID (hDlg, IDS_DSKMAY, MB_ICONINFORMATION) ;
	
	_llseek (hFile, 0L, 0) ;
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	diskinfo.drive = drive ;
	bBadSecCont = FALSE ;
	
	if (b720)
		{
		for (i=0;i<80;i++)
			{
			diskinfo.track = i ;
			
			for (h=0;h<2;h++)
				{
				diskinfo.head = h ;
				diskinfo.buffer = byBuf ;
				diskinfo.sector = 1 ;
				diskinfo.nsectors = 9 ;
				
				if (512*9 != _lread (hFile, byBuf, 512*9) )
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
					
					goto fileerr ;
					}
retry:				
				f = 0 ;
again:
				n = _bios_disk (_DISK_WRITE, &diskinfo) / 256 ;
				if (n && f++ < 1)
					goto again ;
				
				if (n == 0x10 || n == 0x11)
					{
					if (!bBadSecCont)
						{
						ShowCursor (FALSE) ;
						SetCursor (hcurOld) ;
						
						bBadSecCont = MessageID (hDlg, IDS_BADSECTOR, 
							MB_ICONQUESTION | MB_YESNO) == IDYES ;
						
						hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
						ShowCursor (TRUE) ;
						}
					
					if (bBadSecCont)
						{
						// write sector by sector
						diskinfo.nsectors = 1 ;
								
						for (x=1;x<=9;x++)
							{
							diskinfo.sector = x ;
							diskinfo.buffer = byBuf + (x - 1) * 512 ;
										
							switch (_bios_disk (_DISK_WRITE, &diskinfo) / 256)
								{
								case 0:
								case 0x10:
								case 0x11:
									continue ;
											
								default:
									break ;
								}
							}
									
						n = 0 ; // problem resolved
						}
					else
						goto diskerr ;
					}
				
				if (n)
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
					
					if (IDCANCEL == DiskWriteErr (hDlg, n) )
						goto diskerr ;
					
					hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
					ShowCursor (TRUE) ;
					
					goto retry ;
					}
				}
			}
		}
	else
		{
		diskinfo.head = 0 ;
		
		for (i=0;i<80;i++)
			{
			if (512*9 != _lread (hFile, byBuf, 512*9) )
				goto fileerr ;
			
			diskinfo.track = i ;
			diskinfo.buffer = byBuf ;
			diskinfo.sector = 1 ;
			diskinfo.nsectors = 9 ;
			
			if (512*9 != _lread (hFile, byBuf, 512*9) )
				{
				ShowCursor (FALSE) ;
				SetCursor (hcurOld) ;
					
				goto fileerr ;
				}
retry2:		
			f = 0 ;
again2:
			n = _bios_disk (_DISK_WRITE, &diskinfo) / 256 ;
			if (n && f++ < 1)
				goto again2 ;
			
			if (n == 0x10 || n == 0x11)
				{
				if (!bBadSecCont)
					{
					ShowCursor (FALSE) ;
					SetCursor (hcurOld) ;
						
					bBadSecCont = MessageID (hDlg, IDS_BADSECTOR, 
						MB_ICONQUESTION | MB_YESNO) == IDYES ;
						
					hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
					ShowCursor (TRUE) ;
					}
				
				if (bBadSecCont)
					{
					// write sector by sector
					diskinfo.nsectors = 1 ;
					
					for (x=1;x<=9;x++)
						{
						diskinfo.sector = x ;
						diskinfo.buffer = byBuf + (x - 1) * 512 ;
						
						switch (_bios_disk (_DISK_WRITE, &diskinfo) / 256)
							{
							case 0:
							case 0x10:
							case 0x11:
								continue ;
							
							default:
								break ;
							}
						}
					
					n = 0 ; // problem resolved
					}
				else
					goto diskerr ;
				}
			
			if (n)
				{
				ShowCursor (FALSE) ;
				SetCursor (hcurOld) ;
					
				if (IDCANCEL == DiskWriteErr (hDlg, n) )
					goto diskerr ;
					
				hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
				ShowCursor (TRUE) ;
				
				goto retry2 ;
				}
			}
		}
	
	_lclose (hFile) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return TRUE ;
	
fileerr:
	_lclose (hFile) ;
	OpenFile (szFile, NULL, OF_DELETE) ;
	FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
	
	return FALSE ;

diskerr:
	_lclose (hFile) ;
	OpenFile (szFile, NULL, OF_DELETE) ;
	
	return FALSE ;
	}

static BOOL NEAR CopyFile (HWND hDlg, char* szFile1, char* szFile2, BOOL b720)
	{
	HFILE	hFile, hFileOut ;
	BYTE		by ;
	LPBYTE	lpByte ;
	OFSTRUCT	of ;
	HCURSOR	hcurOld ;
	long		lSize ;
	int		i ;
	
	hFile = OpenFile (szFile1, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, hDlg, szFile1) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, hDlg, szFile1) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile1) ;
				break ;
			}
		
		return FALSE ;
		}
	
	if (1 != _lread (hFile, &by, 1) )
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile1) ;
				
		return FALSE ;
		}
	
	lSize = _llseek (hFile, 0L, 2) ;
	
	if ( (by != 0xeb && by != 0xe9) || 
		lSize != (b720 ? 720L * 1024L : 360L * 1024L) )
		{
		_lclose (hFile) ;
		
		FileErr (IDS_FILEDSK, hDlg, szFile1) ;
		
		return FALSE ;
		}
	
	lSize = _llseek (hFile, 0L, 0) ;
	
	if (!NewGlobal ((void FAR**)&lpByte, GMEM_MOVEABLE, 60L * 1024L) )
		{
		_lclose (hFile) ;
		
		return FALSE ;
		}
	
	hFileOut = _lcreat (szFile2, 0) ;
	if (hFileOut == HFILE_ERROR)
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEWRITEUNEXPECT, hDlg, szFile2) ;
				
		return FALSE ;
		}
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	i = b720 ? 12 : 6 ;
	while (i--)
		{
		if (60U * 1024U != _lread (hFile, lpByte, 60U * 1024U) )
			{
			_lclose (hFile) ;
			_lclose (hFileOut) ;
			FreeGlobal ((void FAR**)&lpByte) ;
			
			ShowCursor (FALSE) ;
			SetCursor (hcurOld) ;
			
			FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile1) ;
			OpenFile (szFile2, NULL, OF_DELETE) ;
					
			return FALSE ;
			}
		
		if (60U * 1024U != _lwrite (hFileOut, lpByte, 60U * 1024U) )
			{
			_lclose (hFile) ;
			_lclose (hFileOut) ;
			FreeGlobal ((void FAR**)&lpByte) ;
			
			ShowCursor (FALSE) ;
			SetCursor (hcurOld) ;
			
			FileErr (IDS_FILEWRITEUNEXPECT, hDlg, szFile2) ;
			OpenFile (szFile2, NULL, OF_DELETE) ;
			
			return FALSE ;
			}
		}
	
	FreeGlobal ((void FAR**)&lpByte) ;
	
	_lclose (hFile) ;
	_lclose (hFileOut) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return TRUE ;
	}

// Disk Copy
BOOL FAR PASCAL _export CopyDiskDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char		szFile1[_MAX_PATH], szFile2[_MAX_PATH] ;
	BOOL		bDrvA, bDrvB, b720 ;
	int		i ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// disk size
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz360Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz720Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_SETCURSEL, 1, 0L) ;
			
			if (g_bDriveA)
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
				}
			if (g_bDriveB)
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
				}
			
			if (!g_bDriveA && !g_bDriveB)
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveNone) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveNone) ;
				
				EnableWindow (GetDlgItem (hDlg, IDC_DRVADRVRDO), FALSE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_DRVADRVCMB), FALSE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_DRVBDRVRDO), FALSE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_DRVBDRVCMB), FALSE) ;
				
				SendDlgItemMessage (hDlg, IDC_DRVADSKRDO, BM_SETCHECK, 1, 0L) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDSKRDO, BM_SETCHECK, 1, 0L) ;
				}
			else
				{
				SendDlgItemMessage (hDlg, IDC_DRVADRVRDO, BM_SETCHECK, 1, 0L) ;
				SendDlgItemMessage (hDlg, IDC_DRVBDRVRDO, BM_SETCHECK, 1, 0L) ;
				}
			
			SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, CB_SETCURSEL, 0, 0L) ;
			SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, CB_SETCURSEL, 0, 0L) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
					bDrvA = (int)SendDlgItemMessage (hDlg, IDC_DRVADSKRDO, 
						BM_GETCHECK, 0, 0L) ;
					bDrvB = (int)SendDlgItemMessage (hDlg, IDC_DRVBDSKRDO, 
						BM_GETCHECK, 0, 0L) ;
					b720 = (int)SendDlgItemMessage (hDlg, IDC_SIZECMB, 
						CB_GETCURSEL, 0, 0L) ;
					GetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1, sizeof (szFile1) ) ;
					GetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile2, sizeof (szFile2) ) ;
					
					if (bDrvA)
						{
						if (szFile1[0])
							{
							i = CheckDSKfile (hDlg, szFile1, TRUE) ;
							
							if (!i--)
								return TRUE ;
							
							if (i != b720)
								{
								MessageID (hDlg, IDS_DSKSIZEDIF, MB_ICONEXCLAMATION) ;
								
								b720 = i ;
								}
							}
						else
							{
							MessageID (hDlg, IDS_TYPEFILE, MB_ICONEXCLAMATION) ;
							
							return TRUE ;
							}
						}
					
					if (bDrvB && !szFile2[0])
						{
						MessageID (hDlg, IDS_TYPEFILE, MB_ICONEXCLAMATION) ;
						
						return TRUE ;
						}
					
					if (bDrvA && bDrvB)
						{
						if (!strcmp (szFile1, szFile2) )
							{
							MessageID (hDlg, IDS_DISKFILESAME, MB_ICONEXCLAMATION) ;
							
							return TRUE ;
							}
						
						if (!CopyFile (hDlg, szFile1, szFile2, b720) )
							return TRUE ;
						}
					else if (!bDrvA && !bDrvB)
						{
						// temp file
						GetTempFileName (GetTempDrive ('\0'), g_szDefExt, 
							0, szFile1) ;
						
						i = (int)SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, 
							CB_GETCURSEL, 0, 0L) ;
						if (!CopyDiskToFile (hDlg, i, szFile1, b720) )
							{
							mmioOpen (szFile1, NULL, MMIO_DELETE) ;
							
							return TRUE ;
							}
						
						i = (int)SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, 
							CB_GETCURSEL, 0, 0L) ;
						if (!CopyFileToDisk (hDlg, i, szFile1, b720) )
							{
							mmioOpen (szFile1, NULL, MMIO_DELETE) ;
							
							return TRUE ;
							}
						
						mmioOpen (szFile1, NULL, MMIO_DELETE) ;
						}
					else
						{
						if (bDrvA)
							{
							i = (int)SendDlgItemMessage (hDlg, IDC_DRVBDRVCMB, 
								CB_GETCURSEL, 0, 0L) ;
							if (!CopyFileToDisk (hDlg, i, szFile1, b720) )
								return TRUE ;
							}
						else
							{
							i = (int)SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, 
								CB_GETCURSEL, 0, 0L) ;
							if (!CopyDiskToFile (hDlg, i, szFile2, b720) )
								return TRUE ;
							}
						}
					
				case IDCANCEL:
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_DRVADRVCMB:
					if (HIWORD (lParam) != CBN_SETFOCUS)
						break ;
					
				case IDC_DRVADSKEDIT:
					if (wParam == IDC_DRVADSKEDIT && HIWORD (lParam) != EN_SETFOCUS)
						break ;
					
				case IDC_DRVABROWSEBTN:
					SendDlgItemMessage (hDlg, IDC_DRVADRVRDO, BM_SETCHECK, wParam == IDC_DRVADRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_DRVADSKRDO, BM_SETCHECK, wParam != IDC_DRVADRVCMB, 0L) ;
					
					if (wParam == IDC_DRVABROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1, _MAX_PATH) ;
						if (DSKBrowse (hDlg, szFile1, TRUE) )
							SetWindowText (GetDlgItem (hDlg, IDC_DRVADSKEDIT), szFile1) ;
						}
					
					return TRUE ;
				
				case IDC_DRVBDRVCMB:
					if (HIWORD (lParam) != CBN_SETFOCUS)
						break ;
						
				case IDC_DRVBDSKEDIT:
					if (wParam == IDC_DRVBDSKEDIT && HIWORD (lParam) != EN_SETFOCUS)
						break ;
					
				case IDC_DRVBBROWSEBTN:
					SendDlgItemMessage (hDlg, IDC_DRVBDRVRDO, BM_SETCHECK, wParam == IDC_DRVBDRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_DRVBDSKRDO, BM_SETCHECK, wParam != IDC_DRVBDRVCMB, 0L) ;
					
					if (wParam == IDC_DRVBBROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile1, _MAX_PATH) ;
						if (DSKBrowseNoChk (hDlg, szFile1) )
							SetWindowText (GetDlgItem (hDlg, IDC_DRVBDSKEDIT), szFile1) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

// Disk Format Dialog box
BOOL FAR PASCAL _export FormatDiskDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char		szFile[_MAX_PATH] ;
	int			i, drive ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// disk size
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz360Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_ADDSTRING, 0, 
				(LPARAM)(LPSTR) g_sz720Kb) ;
			SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_SETCURSEL, 1, 0L) ;
			
			// real drive
			if (!g_bDriveA && !g_bDriveB)
				{
				EnableWindow (GetDlgItem (hDlg, IDC_DRVCMB), FALSE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_REALRAD), FALSE) ;
				
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveNone) ;
				}
			
			if (g_bDriveA)
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveA) ;
			if (g_bDriveB)
				SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPSTR)g_szDriveB) ;
			SendDlgItemMessage (hDlg, IDC_DRVCMB, CB_SETCURSEL, 0, 0L) ;
			
			SendDlgItemMessage (hDlg, IDC_REALRAD, BM_SETCHECK, 1, 0L) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
					i = (int)SendDlgItemMessage (hDlg, IDC_SIZECMB, CB_GETCURSEL, 0, 0L) ;
					
					if (SendDlgItemMessage (hDlg, IDC_REALRAD, BM_GETCHECK, 0, 0L) )
						{
						drive = (int)SendDlgItemMessage (hDlg, IDC_DRVADRVCMB, 
								CB_GETCURSEL, 0, 0L) ;
						
						i = QFormatDisk (drive, i) ;
							
						if (i != -1)
							{
							switch (i)
								{
								case 0:
									i = IDS_DISKPROT ;
									break ;
									
								case 2:
									i = IDS_DISKNOTREADY ;
									break ;
									
								default:
									i = IDS_DISKWRITEERR ;
								}
								
							MessageID (hDlg, i, MB_ICONEXCLAMATION) ;
								
							return TRUE ;
							}
						}
					else
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile, sizeof (szFile) ) ;
						if (szFile[0])
							{
							if (!CreateDSKfile (i, szFile) )
								{
								MessageID (hDlg, IDS_SAVEFAIL, MB_ICONEXCLAMATION) ;
								
								return TRUE ;
								}
							}
						else
							{
							MessageID (hDlg, IDS_TYPEFILE, MB_ICONEXCLAMATION) ;
							
						     return TRUE ;
						     }
						}
					
				case IDCANCEL:
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_DRVCMB:
					wParam = IDC_DRVCMB ;
				case IDC_BROWSEBTN:
				case IDC_DISKFILEEDIT:
					SendDlgItemMessage (hDlg, IDC_DISKFILERAD, BM_SETCHECK, wParam != IDC_DRVCMB, 0L) ;
					SendDlgItemMessage (hDlg, IDC_REALRAD, BM_SETCHECK, wParam == IDC_DRVCMB, 0L) ;
					
					if (wParam == IDC_BROWSEBTN)
						{
						GetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile, sizeof (szFile) ) ;
						if (DSKBrowseNoChk (hDlg, szFile) )
							SetWindowText (GetDlgItem (hDlg, IDC_DISKFILEEDIT), szFile) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

